#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Outfile_x64=Notes_Etudiants.Exe
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
; -------------------------------------------------------------------------------
; Nom:     Gestion_Notes_Etudiants.au3
; But:     Permet de faire la gestion des notes de 3 étudiants
;
; Auteur:      Carl Fortin
;
; Créé le:     03-16-2017
; Copyright:   (c) Carl 2017
; -------------------------------------------------------------------------------



#include <ButtonConstants.au3>
#include <ComboConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <ListViewConstants.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <GuiListBox.au3>
#include <GuiListView.au3>
#include <MsgBoxConstants.au3>
#include <StringConstants.au3>
#include <File.au3>


Global $listview_etudiant
Global $GUI_etudiant
;Mon tableau de notes
Global $aTableau_note[3][4]
Global $id_Eleve_1
Global $id_Eleve_2
Global $id_Eleve_3
Global $note_entre = ""
Global $Numero_devoir = ""
Global $Numero_etudiant = ""


; Creation de l'interface

;Rempli mon tableau de notes des étudiants 1 à 3
;Étudiant 1
$aTableau_note[0][0] = "10.5"
$aTableau_note[0][1] = "14"
$aTableau_note[0][2] = "7"
$aTableau_note[0][3] = "11"

;Étudiant 2
$aTableau_note[1][0] = "16"
$aTableau_note[1][1] = "20"
$aTableau_note[1][2] = "17.5"
$aTableau_note[1][3] = "19"

;Étudiant 3
$aTableau_note[2][0] = "3.5"
$aTableau_note[2][1] = "6"
$aTableau_note[2][2] = "1.5"
$aTableau_note[2][3] = "7"
;_ArrayDisplay($aTableau_note)

;Création de mon GUI
$Form1 = GUICreate("Gestionnaire de notes des étudiants - Par Carl Fortin", 702, 358, 658, 216)
Create_Notes_list()
$Combo_Etudiant = GUICtrlCreateCombo("", 80, 208, 161, 25, BitOR($CBS_DROPDOWN, $CBS_AUTOHSCROLL))
GUICtrlSetData(-1, "Etudiant 1|Etudiant 2|Etudiant 3", "Etudiant 1")

$Combo_Devoir = GUICtrlCreateCombo("", 264, 208, 113, 25, BitOR($CBS_DROPDOWN, $CBS_AUTOHSCROLL))
GUICtrlSetData(-1, "Devoir 1|Devoir 2|Devoir 3|Devoir 4", "Devoir 1")
$Notes_input = GUICtrlCreateInput("", 400, 208, 81, 21)
;On limite à 4 digits incluant la virgule
GUICtrlSetLimit($Notes_input, 4, 0)
$Soumettre = GUICtrlCreateButton("Soumettre", 504, 208, 120, 25)
$Calcule_Moy = GUICtrlCreateButton("Calcule", 360, 264, 120, 25)
$Export_Note = GUICtrlCreateButton("Exporter", 360, 304, 121, 25)
$Notes = GUICtrlCreateLabel("Notes des étudiants", 232, 16, 188, 28)
GUICtrlSetFont(-1, 14, 800, 0, "MS Sans Serif")
$Label_Etu = GUICtrlCreateLabel("Numéro de l'étudiant", 80, 184, 101, 17)
$Label_devoir = GUICtrlCreateLabel("Numéro du devoir", 264, 184, 88, 17)
$Label_Notes = GUICtrlCreateLabel("Note", 400, 184, 27, 17)
$Label_export = GUICtrlCreateLabel("Exporter les notes vers un fichier texte:", 160, 312, 186, 17)
$Label_Moyenne = GUICtrlCreateLabel("Calcule la moyenne du 3 ième étudiant:", 160, 272, 189, 17)
GUISetState(@SW_SHOW)



; Main loop
While 1
	$nMsg = GUIGetMsg()
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			Exit

		Case $Soumettre

			Valide_Donnee()

		Case $Calcule_Moy

			Calcule_Moyenne()

		Case $Export_Note

			Exporte_note()

	EndSwitch
WEnd






;Création de la listbox pour les notes
Func Create_Notes_list()


	;Crée la listview avec le nom des colonnes
	$listview_etudiant = GUICtrlCreateListView(" Numéro d'élève|Devoir 1|Devoir 2|Devoir 3|Devoir 4", 72, 48, 555, 85)
	_GUICtrlListView_SetExtendedListViewStyle($listview_etudiant, BitOR($LVS_EX_FULLROWSELECT, $LVS_EX_SUBITEMIMAGES, $LVS_EX_GRIDLINES, $LVS_EX_DOUBLEBUFFER, $LVS_EDITLABELS))

	;Largeur des colonnes
	_GUICtrlListView_SetColumnWidth($listview_etudiant, 0, 150)
	_GUICtrlListView_SetColumnWidth($listview_etudiant, 1, 100)
	_GUICtrlListView_SetColumnWidth($listview_etudiant, 2, 100)
	_GUICtrlListView_SetColumnWidth($listview_etudiant, 3, 100)
	_GUICtrlListView_SetColumnWidth($listview_etudiant, 4, 100)

	;Texte centré dans les colonnes
	_GUICtrlListView_JustifyColumn($listview_etudiant, 0, 2)
	_GUICtrlListView_JustifyColumn($listview_etudiant, 1, 2)
	_GUICtrlListView_JustifyColumn($listview_etudiant, 2, 2)
	_GUICtrlListView_JustifyColumn($listview_etudiant, 3, 2)
	_GUICtrlListView_JustifyColumn($listview_etudiant, 4, 2)
	_GUICtrlListView_JustifyColumn($listview_etudiant, 5, 2)

	;Remplissage de la liste des notes
	;Extraction de chaque ligne du tableau qui corespond à un étudiant dans le tableau de notes
	$id_Eleve_1 = GUICtrlCreateListViewItem("1|" & _ArrayToString((_ArrayExtract($aTableau_note, 0, 0, 0, 3))), $listview_etudiant)
	$id_Eleve_2 = GUICtrlCreateListViewItem("2|" & _ArrayToString((_ArrayExtract($aTableau_note, 1, 1, 0, 3))), $listview_etudiant)
	$id_Eleve_3 = GUICtrlCreateListViewItem("3|" & _ArrayToString((_ArrayExtract($aTableau_note, 2, 2, 0, 3))), $listview_etudiant)

EndFunc   ;==>Create_Notes_list

;Fonction qui modifie la note selon le numéro de l'élève et le numéro de devoir
Func Modification_note($ligne_eleve, $colonne_devoir, $note)

	;Mise à jour du tableau des notes
	$aTableau_note[$ligne_eleve][$colonne_devoir] = $note


	;Choisi le bon numéro de l'élève
	Switch $ligne_eleve
		Case 0
			$id_Eleve = $id_Eleve_1
		Case 1
			$id_Eleve = $id_Eleve_2
		Case 2
			$id_Eleve = $id_Eleve_3
	EndSwitch

	;Choisi le bon devoir de l'élève et inscrit la note dans la listview
	Switch $colonne_devoir

		Case 0
			GUICtrlSetData($id_Eleve, "|" & $note & "||||")
		Case 1
			GUICtrlSetData($id_Eleve, "||" & $note & "|||")
		Case 2
			GUICtrlSetData($id_Eleve, "|||" & $note & "||")
		Case 3
			GUICtrlSetData($id_Eleve, "||||" & $note & "|")

	EndSwitch



EndFunc   ;==>Modification_note


;Fait corespondre le numéro de devoir dans la combobox
;et retourne le bon index
Func Valide_Devoir_Input()


	Switch GUICtrlRead($Combo_Devoir)
		Case "Devoir 1"
			$Numero_devoir = 0
		Case "Devoir 2"
			$Numero_devoir = 1
		Case "Devoir 3"
			$Numero_devoir = 2
		Case "Devoir 4"
			$Numero_devoir = 3

	EndSwitch

	Return $Numero_devoir

EndFunc   ;==>Valide_Devoir_Input

;Fait corespondre le bon numéro de l'élève dans la combobox
;et retourne le bon index
Func Valide_Etudiant()


	Switch GUICtrlRead($Combo_Etudiant)
		Case "Etudiant 1"
			$Numero_etudiant = 0
		Case "Etudiant 2"
			$Numero_etudiant = 1
		Case "Etudiant 3"
			$Numero_etudiant = 2
	EndSwitch

	Return $Numero_etudiant

EndFunc   ;==>Valide_Etudiant

;Retourne la valeur rentré dans note
Func Lire_Notes()

	Return GUICtrlRead(Int($Notes_input))

EndFunc   ;==>Lire_Notes

;Valide les indices de lignes et de colonne
;et renvoie un message d'erreur si il y a un problème
Func Valide_Donnee()

	;Extrait les notes de l'étudiant du tableau note
	$aEtudiant_Select = _ArrayExtract($aTableau_note, Valide_Etudiant(), Valide_Etudiant(), 0, 3)


	;Nombre total de lignes pour chaque étudiant. Doit etre 1
	Local $iRows = UBound($aEtudiant_Select, $UBOUND_ROWS)

	;Nombre total de colonnes pour les numéros de devoir. Doit etre 4
	Local $iCols = UBound($aEtudiant_Select, $UBOUND_COLUMNS)

	If $iRows = 1 And $iCols = 4 Then

		;Vérifie si c'est un nombre valide
		If StringIsDigit(GUICtrlRead($Notes_input)) Or StringIsFloat(GUICtrlRead($Notes_input)) Then

			;Vérifie si la note est entre 0 et 100
			If GUICtrlRead($Notes_input) <= 100 Or GUICtrlRead($Notes_input) <= 0 Then

				Modification_note(Valide_Etudiant(), Valide_Devoir_Input(), Lire_Notes())

			Else

				MsgBox($MB_SYSTEMMODAL, "Attention", "Veuillez entrer une note de 0 à 100")


			EndIf

		Else

			MsgBox($MB_SYSTEMMODAL, "Attention", "Veuillez entrer une nombre!")


		EndIf



		Return True

	Else

		MsgBox($MB_SYSTEMMODAL, "Attention", "Modification impossible")

		Return False

	EndIf


EndFunc   ;==>Valide_Donnee

;Calcule la moyenne du 3ieme étudiant
Func Calcule_Moyenne()
	;Additionne les 4 devoirs et divise par 4 pour trouver la moyenne
	$Moyenne_Etu_3 = ($aTableau_note[2][0] + $aTableau_note[2][1] + $aTableau_note[2][2] + $aTableau_note[2][3]) / 4
	MsgBox($MB_SYSTEMMODAL, "Moyenne", "La moyenne de l'étudiant 3 est " & $Moyenne_Etu_3 & " %")


EndFunc   ;==>Calcule_Moyenne


;Exporte les notes dans un fichier texte
Func Exporte_note()


	;Creation du fichier dans le répertoire du script
	Local $sFilePath = @ScriptDir & "\Notes_Etudiants.txt"


	If Not FileCreate($sFilePath, "*********  NOTES DES ÉTUDIANTS **********" & @CRLF) Then Return MsgBox($MB_SYSTEMMODAL, "", "Une erreur est survenue lors de l'écriture du fichier texte.")

	; Ouvre le fichier en écriture et stocke le handle dans une variable.
	Local $hFileOpen = FileOpen($sFilePath, $FO_OVERWRITE)
	If $hFileOpen = -1 Then
		MsgBox($MB_SYSTEMMODAL, "", "Une erreur est survenue lors de la lecture du fichier.")
		Return False
	EndIf

	; Écrit les  notes des étudiants dans le fichier texte.
	FileWrite($hFileOpen, "*********  NOTES DES ÉTUDIANTS **********" & @CRLF)
	FileWrite($hFileOpen, "Étudiant 1:" & @CRLF)
	FileWrite($hFileOpen, "Devoir 1: " & $aTableau_note[0][0] & @CRLF)
	FileWrite($hFileOpen, "Devoir 2: " & $aTableau_note[0][1] & @CRLF)
	FileWrite($hFileOpen, "Devoir 3: " & $aTableau_note[0][2] & @CRLF)
	FileWrite($hFileOpen, "Devoir 4: " & $aTableau_note[0][3] & @CRLF)

	FileWrite($hFileOpen, "" & @CRLF)

	FileWrite($hFileOpen, "Étudiant 2:" & @CRLF)
	FileWrite($hFileOpen, "Devoir 1: " & $aTableau_note[1][0] & @CRLF)
	FileWrite($hFileOpen, "Devoir 2: " & $aTableau_note[1][1] & @CRLF)
	FileWrite($hFileOpen, "Devoir 3: " & $aTableau_note[1][2] & @CRLF)
	FileWrite($hFileOpen, "Devoir 4: " & $aTableau_note[1][3] & @CRLF)

	FileWrite($hFileOpen, "" & @CRLF)

	FileWrite($hFileOpen, "Étudiant 3:" & @CRLF)
	FileWrite($hFileOpen, "Devoir 1: " & $aTableau_note[2][0] & @CRLF)
	FileWrite($hFileOpen, "Devoir 2: " & $aTableau_note[2][1] & @CRLF)
	FileWrite($hFileOpen, "Devoir 3: " & $aTableau_note[2][2] & @CRLF)
	FileWrite($hFileOpen, "Devoir 4: " & $aTableau_note[2][3] & @CRLF)


	;Voir le fichier
	ShellExecute($sFilePath)


EndFunc   ;==>Exporte_note



; Crée un fichier.
Func FileCreate($sFilePath, $sString)
	; Crée une variable pour stocker une valeur booléenne.
	Local $bReturn = True

	; Si FileWrite retourne 1 ce sera True sinon False.
	If FileExists($sFilePath) = 0 Then $bReturn = (FileWrite($sFilePath, $sString) = 1)

	; Retourne la valeur booléenne True ou False, en fonction de la valeur de retour de FileWrite.
	Return $bReturn
EndFunc   ;==>FileCreate



