
//*************************STEP MOTOR WEBCAM*******************************************************************
//************************Programmer: Carl Fortin**************************************************************
//************************Language:Hi tech C 9.83**************************************************************


#include <pic.h>		                                                       // Inclusion du prototype du PIC 16F
#include  <htc.h>
#include <pic16f1827.h>
#include "delay.h"


#define	_XTAL_FREQ 4000000                                                    // This definition is required to calibrate __delay_us() and __delay_ms()

__CONFIG(FOSC_INTOSC & WDTE_OFF & MCLRE_ON & CP_OFF & CPD_OFF & BOREN_OFF );  //Internal clock,WDT disabled,MCLR/VPP pin function is MCLR,Program memory code protection is disabled,Data memory code protection is disabled,Brown-out Reset disabled
__CONFIG(WRT_OFF & PLLEN_ON & LVP_OFF);                                       //Write protection off,4x PLL enabled,High-voltage on MCLR/VPP must be used for programming

/*                                 DFINITIONS DES CONSTANTES                                */
/*                                 **************************                                */






#define LED1     RA1			        //
#define LED2     RA3			        //
#define CW       RA2					//
#define HOME     RA4			        //
#define CLOCK    RA6					//
#define CONTROL  RA7				    //
#define HALFFULL RB5			        //
#define ENABLE   RB4			        //
#define IDLE_TIMEOUT   360			    //360 = 3 minutes


/*                              DCLARATION DES VARIABLES GLOBALES                           */
/*                              **********************************                           */
unsigned char rx_buffer[6];
unsigned char Motor_Command      		  =0;
unsigned char RX_DATA_RS232_BYTE_1		  =0;
unsigned char RX_DATA_RS232_BYTE_2		  =0;
unsigned char Motor_degree_now_BYTE_1	  =0;
unsigned char Motor_degree_now_BYTE_2	  =1;
unsigned char flag_rx	                  =0;
unsigned int  RS_232_Time_Out             =0;
unsigned int Motor_degree  			      =0;
unsigned int Motor_degree_now             =0;
unsigned int Timer_Count                  =0; 
 
volatile unsigned char Iddle_motor_flag   =0;  //Force le compilateur  lire la valeur et executer le code peu importe la situation
volatile unsigned char RX_flag            =0;  //Force le compilateur  lire la valeur et executer le code peu importe la situation


/*                      DCLARATION DES PROTOTYPES DES FONCTIONS INTERNES                    */
/*                      *************************************************                    */

void _delay(unsigned long cycles);
void Init_chip(void);
void Timer_1_Init(void);
void L6208_Init(void);
void RS_232_Init (void);
void Move_step_motor (void);
void Read_last_motor_position (void);
void Stop_Step_Motor_Driver(void);
void Reset_timer_1 (void);
void Process_Command_From_PC (void);
void Read_UART (void);
void Write_UART_To_PC (void);
void USARTWriteByte(char ch);
unsigned char USARTReadByte();
/*                               ENTRE DU PROGRAMME PRINCIPAL                               */
/*                               *****************************                               */

void main( )

{                                               //Dbut du programme principale

	Init_chip();
    L6208_Init();
	RS_232_Init();
    LED1 = 1;
    LED2 = 0;
    Timer_1_Init();
    
   	while(1)
	{

            if(RX_flag==1)
			{
			 Process_Command_From_PC();
		     Reset_timer_1();             //Remet le timer1 en fonction pour recommencer  compter
			 RX_flag = 0; 
			
			}

   			if(Iddle_motor_flag  == 1)   //3 minutes se sont couls sans aucune activit, on ferme le moteur
            {
    	     Stop_Step_Motor_Driver();
             Iddle_motor_flag = 0;
    		}
           

    }  

}       //Fin du programme principale
	

void interrupt routine (void)

{
   if(RCIF==1)
   {
    Read_UART();   //Lis la commande envoy par le PC et bouge le moteur si il y lieu
    return;
   }

   if(TMR1IF==1)   // 65536 x 8us =  0.5 secondes
   {
    Timer_Count ++;
    TMR1IF = 0;
   

    if (Timer_Count == IDLE_TIMEOUT)

      {
      TMR1ON = 0;  //Dsactivwe le timer car on en n'a plus besoin
      TMR1IE = 0;
      Iddle_motor_flag = 1;
      }
     
   }
  
}


void RS_232_Init (void)

{
 
 SPBRG = 25; //Baud rate = 9600 for 4 MHz clock
 BRGH=1;	 //data rate for sending
 SYNC=0;	 //asynchronous
 SPEN=1;	 //enable serial port pins
 CREN=1;	 //enable reception
 SREN=0;	 //no effect
 TXIE=0;	 //disable tx interrupts
 RCIE=1;	 //enable rx interrupts
 TX9=0;		 //8-bit transmission
 RX9=0;		 //8-bit reception
 TXEN=0;	 //reset transmitter
 TXEN=1;	 //enable the transmitter

}	
	
unsigned char USARTReadByte()
{   
       
	while((RS_232_Time_Out >= 1) && (!RCIF)) //Attend qu'une byte soit recu et tant que le timeout n'expire pas
    {
     RS_232_Time_Out--;
    }

    return RCREG;
}

void Read_UART (void)

{
  
    
    int a = 5;                                  //5 bytes sont attendu du PC
    
    for (a = 0 ; a < 5 ; a++)                   //Rammasse les 5 bytes
    {
     RS_232_Time_Out = timeout_int_us(10000);  //Remet le timeout en fonction
     rx_buffer[a] = USARTReadByte();
    }

    if(RS_232_Time_Out ==0)
    {
     //TimeOut Dtect fais rien et ignore la requete
    }
    else
    RX_flag = 1;                               //Active le flag qui indique une bonne rception
  

}


void Write_UART_To_PC (void)               //Envoie les 3 bytes au PC

{
  USARTWriteByte(Motor_degree_now_BYTE_1); //Envoie la dernire position du moteur au PC LSB
  USARTWriteByte(Motor_degree_now_BYTE_2); //Envoie la dernire position du moteur au PC MSB
  USARTWriteByte(Motor_Command);  		   //Envoie la rponse que la comande est recu
}

void Process_Command_From_PC (void)

{

RX_DATA_RS232_BYTE_1    = rx_buffer[0]; 	//LSB des step  faire
RX_DATA_RS232_BYTE_2    = rx_buffer[1];		//MSB des step  faire
Motor_Command           = rx_buffer[2];		//Commande
Motor_degree_now_BYTE_1 = rx_buffer[3];		//LSB de la position actuel
Motor_degree_now_BYTE_2 = rx_buffer[4];		//MSB de la position actuel

Motor_degree = RX_DATA_RS232_BYTE_2;        //MSB
Motor_degree <<= 8;                         //Place le MSB
Motor_degree ^= RX_DATA_RS232_BYTE_1;       //Place le LSB 


Motor_degree_now = Motor_degree_now_BYTE_2; //MSB
Motor_degree_now <<= 8;                     //Place le MSB des degrs actuel
Motor_degree_now ^= Motor_degree_now_BYTE_1;//Place le LSB des degrs actuel

switch(Motor_Command)

	{

       case 1: //Clockwise
       CW = 1;
	   Move_step_motor();
       break;

       case 2:  //Counter clockwise
       CW = 0;
       Move_step_motor();
       break;

       case 3:  //Envoie la valeur sauvegard dans le EEPROM au PC
       Read_last_motor_position();                           //Lis la dernire position du moteur
       Write_UART_To_PC();
       break;


	   case 4:  //Commande pour mettre la position  1 (home)
	   Motor_degree_now = 1;
       EEPROM_WRITE(0x01, Motor_degree_now_BYTE_2);          //Sauvegarde la position du moteur dans le EEPROM
       EEPROM_WRITE(0x02, Motor_degree_now_BYTE_1);
       Write_UART_To_PC();
	   break;

       case 6:  //Commande pour arreter le driver car l'application est sortie
	   ENABLE   =  0;   //Ferme le L6208
       Write_UART_To_PC();
       break;

	}

}



void USARTWriteByte(char ch)
{
	//Wait for TXREG Buffer to become available
	while(!TXIF);

	//Write data
	TXREG=ch;
}


void Stop_Step_Motor_Driver(void)
{
	   ENABLE = 0;
	   Motor_Command = 6;                        //Commande qui indique au PC qu'on ferme le L6208 du a une inactivit
	   Write_UART_To_PC();
}

void Move_step_motor (void)

{

  
  if(Motor_degree <= 400 )  //Si la valeur envoy par le PC plus petite que 400, on bouge le moteur.(protection)

  {
   
   ENABLE   =  1;   //Ouvre le L6208
   LED1 = 0;
   LED2 = 1;
   int a;
    
    if(HALFFULL ==  1)  //Half step multiplie par 2 pour donner 400 compte
    {
     Motor_degree = Motor_degree * 2;
    }

    for (a = 0 ; a < Motor_degree ; a++)

    {
    CLOCK = 1;
    __delay_ms(10);
	CLOCK = 0;
    }

   LED1 = 1;
   LED2 = 0;
   Motor_Command = 5;   //Indique au PC que le moteur  fini de tourner
   Write_UART_To_PC();
   EEPROM_WRITE(0x01, Motor_degree_now_BYTE_2);  //Sauvegarde la position du moteur dans le EEPROM
   EEPROM_WRITE(0x02, Motor_degree_now_BYTE_1);
   
   }
   
   
}

void Read_last_motor_position (void)
{

   Motor_degree_now_BYTE_2 = EEPROM_READ(0x01); //Lis la dernire position du moteur MSB
   Motor_degree_now_BYTE_1 = EEPROM_READ(0x02); //Lis la position position du moteur LSB
   Motor_degree_now = Motor_degree_now_BYTE_2;  //MSB
   Motor_degree_now <<= 8;                      //Place le MSB
   Motor_degree_now ^= Motor_degree_now_BYTE_1; //Place le LSB 

   if (Motor_degree_now > 400)                   //Empeche une mauvaise lecture si le EEPROM n'a jamais t crit
   {
     Motor_degree_now_BYTE_1 = 1;
     Motor_degree_now_BYTE_2 = 0;
    
   }


}
	
void L6208_Init (void)

{

ENABLE   =  0;	//Chip Enable. LOW logic level switches OFF all Power MOSFETs of both Bridge A and Bridge B.
CONTROL  =  0;  //Decay Mode Selector. HIGH logic level sets SLOW DECAY Mode. LOW logic level sets FAST DECAY Mode.
HALFFULL =  1;  //Step Mode Selector. HIGH logic level sets HALF STEP Mode, LOW logic level sets FULL STEP Mode.
HOME     =  1;  //Reset Pin. LOW logic level restores the Home State(State 1) on the Phase Sequence Generator State Machine.If not used, it has to be connected to +5V.
CW       =  1;	//Selects the direction of the rotation. HIGH logic level sets clockwise direction, whereas LOW logic level sets counterclockwise direction. 
CLOCK    =  0;  //Step Clock input. The state machine makes one step on each rising edge.
Motor_Command = 0;
}

void Reset_timer_1 (void)

{
     TMR1L = 0;
     TMR1H = 0;
	 Timer_Count = 0;       //Timer qui est remis  zro
     TMR1ON = 1;	    	//Active le timer 1
     TMR1IE = 1;	    	//Active intruption du timer
     Iddle_motor_flag = 0;  //Remet le flag du iddle  zro
}


void Timer_1_Init (void)

 {

 T1CON = 0b00111100;          //Enables Timer1, Internal clock (FOSC/4) ,1:1 Prescale value 1uS
         //--11----           T1CKPS1:T1CKPS0: Timer1 Input Clock Prescale Select bits 1MHZ / 8 = 8 us
	     //----1---   	      T1OSCEN: Timer1 Oscillator Enable Control bit
	     //-----1--    		  T1SYNC: Timer1 External Clock Input Synchronization Control bit
	     //------0-  	      TMR1CS: Timer1 Clock Source Select bit
	     //-------0   		  TMR1ON: Timer1 On bit
T1GCON = 0b0000000;	    

 __delay_ms(1);               //Attend que l'oscillateur se stabilise
 
 
 }

void Init_chip (void)

{

OSCCON = 0b01101010;  //OSCILLATOR CONTROL REGISTER
         //0-------   Software PLL Enable bit
	     //-1101---	  Internal Oscillator Frequency Select bits (4MHz)
	     //------10   System Clock Select bits 

ANSELA = 0b00000001; 	 //Input mode I/O pin to digital sauf pour RA0 en analog input
PORTA =  0;				 //Tout est  zro en partant
TRISA =  0b00000001;	 //Tous les bits en sortie sauf RA0 pour conversion analogique
WPUA =   0b00000000;	 //WEAK PULL-UP Disabled on port A
ENABLE = 0;              //L6208 inactif  recevoir des donnes au dpart

ANSELB = 0;	           	 //Input mode I/O pin to digital
PORTB = 0;
TRISB = 0b00000010;	     //ENTRE:RB1 pour RX ,SORTIE: le reste pour le L6208 stepmotor driver
WPUB =  0b11111111;		 //WEAK PULL-UP enabled on port B

OPTION_REG = 0b00000000;  //TMR0  prescaler/WDT  postscaler 
             //0-------   RBPU: PORTB Pull-up Enable bit
	         //-0------	  INTEDG: Interrupt Edge Select bit
	         //--0-----   T0CS: TMR0 Clock Source Select bit
	         //---0----   T0SE: TMR0 Source Edge Select bit
	         //----0---   PSA: Prescaler Assignment bit
	         //-----000   PS2:PS0: Prescaler Rate Select bits    

INTCON = 0b11000000;  //Register is a readable and writable register, which contains various enable and flag bits
         //1-------   GIE: Global Interrupt Enable bit 
	     //-1------	  PEIE: Peripheral Interrupt Enable bit
	     //--0-----   T0IE: TMR0 Overflow Interrupt Enable bit
	     //---0----   INTE: RB0/INT External Interrupt Enable bit
	     //----0---   RBIE: RB Port Change Interrupt Enable bit 
	     //-----0--   T0IF: TMR0 Overflow Interrupt Flag bit
	     //------0-   INTF: RB0/INT External Interrupt Flag bit
	     //-------0   RBIF: RB Port Change Interrupt Flag bit 

PIE1 = 0b00000000;   //The PIE1 register contains the individual enable bits for the peripheral interrupts.
       //0-------    PSPIE(1): Parallel Slave Port Read/Write Interrupt Enable bit
	   //-0------	 ADIE:     A/D Converter Interrupt Enable bit
	   //--0-----    RCIE:     USART Receive Interrupt Enable bit
	   //---0----    TXIE:     USART Transmit Interrupt Enable bit
	   //----0---    SSPIE:    Synchronous Serial Port Interrupt Enable bit
	   //-----0--    CCP1IE:   CCP1 Interrupt Enable bit
	   //------0-    TMR2IE:   TMR2 to PR2 Match Interrupt Enable bit
	   //-------0    TMR1IE:   TMR1 Overflow Interrupt Enable bit
	   
	   
PIE2 = 0b00000000;   //Individual enable bits for the  CCP2  peripheral  interrupt
       //-0------	  Reserved Always maintain this bit clear
	   //---0----     EEPROM Write Operation Interrupt Enable
	   //----0---     BCLIE:  Bus Collision Interrupt Enable
	   //-------0     CCP2IE: CCP2 Interrupt Enable bit
	   	   
PIR1 = 0b00000000;   //Individual flag bits for the peripheral interrupts.
       //0-------    PSPIF:  Parallel Slave Port Read/Write Interrupt Flag bit
	   //-0------	 ADIF:   A/D Converter Interrupt Flag bit
	   //--0-----    RCIF:   USART Receive Interrupt Flag bit
	   //---0----    TXIF:   USART Transmit Interrupt Flag bit
	   //----0---    SSPIF:  Synchronous Serial Port (SSP) Interrupt Flag
	   //-----0--    CCP1IF: CCP1 Interrupt Flag bit
	   //------0-    TMR2IF: TMR2 to PR2 Match Interrupt Flag bit
	   //-------0    TMR1IF: TMR1 Overflow Interrupt Flag bit
}