#include <pic.h>		              // Inclusion du prototype du PIC 16F
#include  <htc.h>
#include <pic16f1827.h>
#include  <math.h>

//__CONFIG(WDTDIS & XT & UNPROTECT & LVPDIS & BORDIS);   //Watchdog disabled,4MHz,Unprotect,Low Voltage Disabled


/*                                 DFINITIONS DES CONSTANTES                                */
/*                                 **************************                                */




#define	_XTAL_FREQ 4000000              // This definition is required to calibrate __delay_us() and __delay_ms()

#define ENABLE RA1					    //Enable MC14489 7segment driver
#define Active_relay RA2                //Active relay
#define	LED_BICOLOR_PIN_1 RA3           // Led bicolor sur RA3
#define	LED_BICOLOR_PIN_2 RA4           // Led bicolor sur RA4
#define VACUUM_SW RB3	                //SWITCH pour vacuum
#define ZERO_CROSSING_DETECT RB5	    //Dtection zro crossing
#define Minimum_amp_value  5			//5 = 0.5 ampere

/*                              DCLARATION DES VARIABLES GLOBALES                           */
/*                              **********************************                           */

bit Vacuum_Status               = 0;		   //Est-ce que la vacuum est allum ou teint
bit Switch_Status               = 0;


unsigned char Config_MC14489    = 0;
unsigned char Display_register  = 0;
unsigned char BANK_1_NIBBLE     = 0;
unsigned char SPI_DATA_IN       = 0;
unsigned char DUMMY_NIBBLE      = 0;
unsigned char DIGIT_1           = 0;
unsigned char DIGIT_2           = 0;
unsigned char DOT               = 0;

unsigned int AdcValue           = 0;
unsigned int Vacuum_off_count   = 0;
unsigned int Amp_value          = 0;



/*                      DCLARATION DES PROTOTYPES DES FONCTIONS INTERNES                    */
/*                      *************************************************                    */

void _delay(unsigned long cycles);
void Init_chip(void);
void Timer_1_Init(void);
void Timer0_init(void);
void SPI_Init(void);
void Vacuum_Off(void);
void Vacuum_On(void);
void Write_MC14489_SPI(void);
void MC14489_Init(void);
void adc_init(void);
void ADC_get(void);
void Calculate_Amp_Display(void);
void Vacuum_on_timer(void);
void Vacuum_off_timer(void);
 
/*                               ENTRE DU PROGRAMME PRINCIPAL                               */
/*                               *****************************                               */

void main( )

{                                               //Dbut du programme principale

	Init_chip();
    SPI_Init();									//Active SPI
    Timer_1_Init();                  		 	//Active Timer 1
    Timer0_init();
    MC14489_Init();						    	//Init 7 segment driver
    adc_init();
    __delay_ms(1);                             //Attend que l'oscillateur se stabilise
   	Vacuum_Off();                              //Vacuum Off au dpart
    Switch_Status = 0;
	

		while(1)

		{

		              

			if (Amp_value>Minimum_amp_value)     //Si le courant mesur dpasse 0.5 amp on dcolle la balayeuse

		 	{
             Vacuum_on_timer();                  //Attend une seconde avant de dcoller la balayeuse pour viter une surge
		     Vacuum_On();
		 	}

			if (VACUUM_SW == 1)
			{
		     Vacuum_On();
			 Switch_Status = 1;
            __delay_ms(10);
		 	}


            if ((VACUUM_SW == 0) && (Switch_Status == 1))
            {
			 Vacuum_Off();
			 Switch_Status = 0;
             __delay_ms(10);
		    }

			if ((Amp_value<Minimum_amp_value) && (Switch_Status == 0))     //Si le courant mesur est plus petit que 1 amp on dcolle la balayeuse
            {
		        	if (Vacuum_Status == 1)   //La balayeuse est allum et la switch est inactive pars le timer avant d'teindre

		        	{
                    	Vacuum_off_timer();

               		}

				Vacuum_Off();

			 }
      	}  

}       //Fin du programme principale
	

void Write_MC14489_SPI (void)

{
 
  
  Display_register = (0b10000000  | DOT);     //High display mode et BANK 5 non utilis dot bit bank 2
  DUMMY_NIBBLE =     0b00000000;              //BANK 4 et 3 non utilis
  BANK_1_NIBBLE = ((DIGIT_2 << 4) | DIGIT_1); //Digit 1 et 2 rasssembl dans le meme octet
  
  DUMMY_NIBBLE = 0;
  
   ENABLE = 0;                                //ENABLE pin cleared on MC14489 (Dbut du transfert)
  __delay_ms(2);
  
  SSP1BUF=Display_register;						  
  SPI_DATA_IN = SSP1BUF;
  __delay_ms(2);  
  
  
  SSP1BUF=DUMMY_NIBBLE;						  
  SPI_DATA_IN = SSP1BUF;
  __delay_ms(2);
  
  SSP1BUF=BANK_1_NIBBLE;						  
  SPI_DATA_IN = SSP1BUF;
  __delay_ms(2);
  
   
  ENABLE = 1;							  ///ENABLE pin = 1 on  MC14489(Fin du transfert)
  __delay_ms(2);
  
}

void Vacuum_off_timer (void)


{

TMR0IE   = 1;             //Active timer0
TMR0     = 0;               //Commence a compter a 0
Vacuum_off_count = 0;

 while(Vacuum_off_count<60)  //3.8 secondes avant de fermer la balayeuse
 {
   //Attend quelques secondes pour vider le tuyau
 }

 TMR0IE   = 0;             //Dsactive timer0

}

void Vacuum_on_timer (void)


{

TMR0IE   = 1;             //Active timer0
TMR0     = 0;               //Commence a compter a 0
Vacuum_off_count = 0;

 while(Vacuum_off_count<18)  //1 secondes avant d'ouvrir la balayeuse
 {
   //Attend 1 seconde
 }

 TMR0IE   = 0;             //Dsactive timer0

}


void MC14489_Init(void)

{

   Config_MC14489 = 0b0000001;           //C0 = normal mode     
   ENABLE = 0;                           //ENABLE pin set on MC14489 (Dbut du transfert)
  __delay_ms(2);
  
  SSP1BUF=Config_MC14489; 				  
  SPI_DATA_IN = SSP1BUF;                  //Lecture de SDI (Rponse)                   
  __delay_ms(2);
  
  ENABLE = 1;							  //ENABLE pin = 0 on  MC14489(Fin du transfert)
  __delay_ms(2);
  	
}
       
void ADC_get (void)

{

AdcValue = 0;   //reset AdcValue
Amp_value = 0;  //reset AdcValue

ADGO = 1;
while(ADGO)
{
//Attend la fin de convertion ADC
}
AdcValue = ADRESH; 
AdcValue <<= 8;
AdcValue ^= ADRESL;

}

void Calculate_Amp_Display(void)

{

	Amp_value = AdcValue*5;       
	Amp_value = Amp_value/34;     //34 compte = 0.5 amp

		if (Amp_value<10)         //Plus petit que 1 amp

 		{
		DOT = 0b00010000;
  		DIGIT_1 = 0;
  		DIGIT_2 = Amp_value;
 		}

		if (Amp_value>10 & Amp_value<100)     //Entre 1 amp et 10

 		{
		DOT = 0b00010000;
  		DIGIT_1 = (Amp_value/10);
  		DIGIT_2 = (Amp_value-(10*DIGIT_1));
 		}

		if (Amp_value>100)                    //10 amp et plus

 		{
		DOT = 0b00000000;
		Amp_value = (Amp_value/10);
  		DIGIT_1 = (Amp_value/10);
  		DIGIT_2 = (Amp_value-10);
		}

 }




void Vacuum_Off(void)

{

while(ZERO_CROSSING_DETECT == 0)

{
//Attend le passage  zro
}

Active_relay = 0;
LED_BICOLOR_PIN_1 = 0;  //Allume rouge
LED_BICOLOR_PIN_2 = 1;
Vacuum_Status = 0;
}


void Vacuum_On(void)

{

while(ZERO_CROSSING_DETECT == 0)

{
//Attend le passage  zro
}

Active_relay = 1;
LED_BICOLOR_PIN_1 = 1;  //Allume vert
LED_BICOLOR_PIN_2 = 0;
Vacuum_Status = 1;

}

void SPI_Init (void)

{

SSP1STAT= 0b01000000;                          //SYNC SERIAL PORT STATUS REGISTER 
          //0-------                           Input data sampled at middle of data output time (SMP)
		  //-1------						   Data transmitted on rising edge of SCK (CKE)
		  //-------0						   Buffer Full Status bit (BF)
		  
SSP1CON1= 0b00100000;						   //SYNC SERIAL PORT CONTROL REGISTER
 		  //0-------                           Collision Detect bit     (0 = No collision)									  
          //-0------                           Receive Overflow Indicator bit (0 = No collision)
		  //--1-----						   Enables serial port and configures SCK, SDO, SDI, and SS as the source of the serial port pins (SSPEN)
		  //---0----						   Clock Polarity Select bit (0 = Idle state for clock is a low level)
		  //----0000						   SPI Master mode, clock = FOSC/4 (Clock = 1 MHz) 
}




void Timer0_init (void)

{
/*                                    Initialisation du timer0                                */

INTEDG = 0;                  //Interrupt on the falling edge
TMR0CS = 0;                  //Timer0 aliment par clock interne
PSA    = 0;                  //Le prescaler est pour le timer0
PS0    = 1;                  //(Fosc / 4) = 1 Mhz Divis par 256 pour une frquence de 4KHz = 250 Us par coup de clock
PS1    = 1;
PS2    = 1;
TMR0IE   = 0;                 //Interruption non permise
TMR0IF   = 0;
TMR0   = 0;                   //Commence a compter a 0

}

void Timer_1_Init (void)

 {

 T1CON = 0b00111101;          //Enables Timer1, Internal clock (FOSC/4) ,1:1 Prescale value 1uS
         //--11----           T1CKPS1:T1CKPS0: Timer1 Input Clock Prescale Select bits 1MHZ / 8 = 8 us
	     //----1---   	      T1OSCEN: Timer1 Oscillator Enable Control bit
	     //-----1--    		  T1SYNC: Timer1 External Clock Input Synchronization Control bit
	     //------0-  	      TMR1CS: Timer1 Clock Source Select bit
	     //-------1   		  TMR1ON: Timer1 On bit
T1GCON = 0b0000000;	    

 __delay_ms(1);               //Attend que l'oscillateur se stabilise
 TMR1L = 0;
 TMR1H = 0;

 }
void adc_init (void)

{

FVRCON = 0b10001010;          //ADC voltage reference set to 2.048V
ADCON1 = 0b10000011;          //Vref connected to FVR 2.048 V FOSC/2
ADCON0 = 0b00000000;          //AN0 selected

ADON   = 1;                   //ADC enabled
__delay_us(10); 

}


void interrupt routine (void)

{

    
   if(TMR1IF==1)   // 65536 x 8us =  0.5 secondes get adc et refresh 7 segment

   {
     ADC_get();
	 Calculate_Amp_Display();
	 Write_MC14489_SPI();
     TMR1IF = 0;
   }

   if(TMR0IF==1)  //250us * 255 = 64 ms
   {
	Vacuum_off_count ++;
    TMR0IF = 0;
   }


}



void Init_chip (void)

{

OSCCON = 0b01101010;  //OSCILLATOR CONTROL REGISTER
         //0-------   Software PLL Enable bit
	     //-1101---	  Internal Oscillator Frequency Select bits (4MHz)
	     //------10   System Clock Select bits 

ANSELA = 0b00000001; 	 //Input mode I/O pin to digital sauf pour RA0 en analog input
PORTA =  0;				 //Tout est  zro en partant
TRISA =  0b00000001;	 //Tous les bits en sortie sauf RA0 pour conversion analogique
WPUA =   0b00000000;	 //WEAK PULL-UP Disabled on port A
ENABLE = 1;              //MC14489 inactif  recevoir des donnes au dpart

ANSELB = 0;	           	 //Input mode I/O pin to digital
PORTB = 0;
TRISB = 0b00101011;	     //ENTRE: RBO pour Intterupt, RB1 pour SDI, RB5 pour Zero crossing detect, RB3 pour switch vacuum
WPUB =  0b11111111;		 //WEAK PULL-UP Enabled on port B

OPTION_REG = 0b00000000;  //TMR0  prescaler/WDT  postscaler 
             //0-------   RBPU: PORTB Pull-up Enable bit
	         //-0------	  INTEDG: Interrupt Edge Select bit
	         //--0-----   T0CS: TMR0 Clock Source Select bit
	         //---0----   T0SE: TMR0 Source Edge Select bit
	         //----0---   PSA: Prescaler Assignment bit
	         //-----000   PS2:PS0: Prescaler Rate Select bits    

INTCON = 0b11010000;  //Register is a readable and writable register, which contains various enable and flag bits
         //1-------   GIE: Global Interrupt Enable bit 
	     //-1------	  PEIE: Peripheral Interrupt Enable bit
	     //--0-----   T0IE: TMR0 Overflow Interrupt Enable bit
	     //---1----   INTE: RB0/INT External Interrupt Enable bit
	     //----0---   RBIE: RB Port Change Interrupt Enable bit 
	     //-----0--   T0IF: TMR0 Overflow Interrupt Flag bit
	     //------0-   INTF: RB0/INT External Interrupt Flag bit
	     //-------0   RBIF: RB Port Change Interrupt Flag bit 

PIE1 = 0b00000001;   //The PIE1 register contains the individual enable bits for the peripheral interrupts.
       //0-------    PSPIE(1): Parallel Slave Port Read/Write Interrupt Enable bit
	   //-0------	 ADIE:     A/D Converter Interrupt Enable bit
	   //--0-----    RCIE:     USART Receive Interrupt Enable bit
	   //---0----    TXIE:     USART Transmit Interrupt Enable bit
	   //----0---    SSPIE:    Synchronous Serial Port Interrupt Enable bit
	   //-----0--    CCP1IE:   CCP1 Interrupt Enable bit
	   //------0-    TMR2IE:   TMR2 to PR2 Match Interrupt Enable bit
	   //-------1    TMR1IE:   TMR1 Overflow Interrupt Enable bit
	   
	   
PIE2 = 0b00000000;   //Individual enable bits for the  CCP2  peripheral  interrupt
       //-0------	  Reserved Always maintain this bit clear
	   //---0----     EEPROM Write Operation Interrupt Enable
	   //----0---     BCLIE:  Bus Collision Interrupt Enable
	   //-------0     CCP2IE: CCP2 Interrupt Enable bit
	   	   
PIR1 = 0b00000000;   //Individual flag bits for the peripheral interrupts.
       //0-------    PSPIF:  Parallel Slave Port Read/Write Interrupt Flag bit
	   //-0------	 ADIF:   A/D Converter Interrupt Flag bit
	   //--0-----    RCIF:   USART Receive Interrupt Flag bit
	   //---0----    TXIF:   USART Transmit Interrupt Flag bit
	   //----0---    SSPIF:  Synchronous Serial Port (SSP) Interrupt Flag
	   //-----0--    CCP1IF: CCP1 Interrupt Flag bit
	   //------0-    TMR2IF: TMR2 to PR2 Match Interrupt Flag bit
	   //-------0    TMR1IF: TMR1 Overflow Interrupt Flag bit


}