﻿Public Class Form1
    

    Dim SEND_DATA_TO_PIC() As Byte = {TX_DATA_RS232_BYTE_1, TX_DATA_RS232_BYTE_2, Motor_Command, TX_MOTOR_POSITION_BYTE_1, TX_MOTOR_POSITION_BYTE_2} '5 octets envoyés au PIC

    Dim Motor_Command As Byte
    Dim PIC_Command_Answer As Byte
    Dim TX_DATA_RS232_BYTE_1 As Byte
    Dim TX_DATA_RS232_BYTE_2 As Byte
    Dim TX_MOTOR_POSITION_BYTE_1 As Byte
    Dim TX_MOTOR_POSITION_BYTE_2 As Byte
    Dim Motor_degree_array() As Byte
    Dim Motor_position_array() As Byte

    Dim Motor_degree_now As UShort = 1
    Dim Previous_Motor_degree As UShort = 1
    Dim Motor_degree As UShort = 1  '65535 16 bits pour PIC

    Dim Debounce_time As Integer
    Dim bytes As Integer
    Dim offset As Integer = 0
    Dim Pause_time_ms As Integer = 600
    Dim Port_selected As String
    Dim Port_names_listing As String()
    Dim PIC_answer As String


    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        Motor_Command = 6      'indique au PIC de désactiver le Driver du moteur pour sauver du courant
        SEND_DATA_TO_PIC = {TX_DATA_RS232_BYTE_1, TX_DATA_RS232_BYTE_2, Motor_Command, TX_MOTOR_POSITION_BYTE_1, TX_MOTOR_POSITION_BYTE_2}
        SerialPort.Write(SEND_DATA_TO_PIC, 0, SEND_DATA_TO_PIC.Length)
        SerialPort.Close()
        My.Settings.Com_Selected = Port_selected              'Enregistre le nom du port dans my settings
        My.Settings.Save()

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load


        TrackBar1.Enabled = 0         'la trackbar pour bouger le moteur est désactivé tant que le PIC n'a pas envoyé sa dernière position
        LED_Verte.Visible = False
        LED_rouge.Visible = True  'Led rouge qui indique aucune réponse du PIC ou driver L6208 désactivé

        Serial_Port_Detection()

    End Sub
    Public Sub Serial_Port_Detection()

        Port_names_listing = System.IO.Ports.SerialPort.GetPortNames() 'get ports names

        For I = 0 To (Port_names_listing.Length - 1)            'fill select box

            COM_Select_Box.Items.Add(Port_names_listing(I))

        Next I


        If Port_names_listing(0) = "" Then

            MsgBox("Aucun port détecté!")

        Else

            Port_selected = My.Settings.Com_Selected              'Va chercher le dernier port utilisé


            If Port_selected = "" Then   'Si il n'y a pas de port enregistré va chercher le premier trouvé

                Port_selected = Port_names_listing(0)

            Else
                Port_selected = My.Settings.Com_Selected              'Va chercher le dernier port utilisé  
            End If


            Try
                Open_com_port()


            Catch ex As Exception

                MessageBox.Show("Le " & Port_selected & " est déja utilisé")

            End Try



        End If



    End Sub

    Private Sub Timer1_Tick_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick

        If PIC_Command_Answer = 3 Then                    'Le PIC a envoyé sa dernière position?

            TrackBar1.Enabled = 1
            Timer1.Enabled = False                        'Arette le timer car le PIC à répondu
            Previous_Motor_degree = Motor_degree_now      'La position que le pic donne doit égaler Previous_motor_degre
            Degree_TextBox.Text = Previous_Motor_degree
            TrackBar1.Value = Previous_Motor_degree
            ProgressBar1.Value = Previous_Motor_degree
            LED_Verte.Visible = True                    'Led verte qui indique une réponse du PIC
            LED_rouge.Visible = False
            PIC_Command_Answer = 5                        'Force le flag pour qui détermine que le PIC est pret à recevoir la première commande

        Else

            Get_Motor_position_from_pic()

        End If

    End Sub

    Private Sub TrackBar1_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar1.Scroll


        Motor_degree_now = TrackBar1.Value
        ProgressBar1.Value = TrackBar1.Value
        Degree_TextBox.Text = Motor_degree_now


    End Sub
    Private Sub TrackBar1_MouseUp(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar1.MouseUp 'Envoie la commande de bouger le moteur lorsque le slider est relaché


        If PIC_Command_Answer = 5 Or PIC_Command_Answer = 4 Then   'Le PIC a terminé de bouger le moteur on peut envoyer une nouvelle commande


            If Motor_degree_now <> Previous_Motor_degree Then   'Si la position du moteur choisi est différente que la précédente, on bouge le moteur

                Calculate_Step_motor()
                Motor_degree_array = BitConverter.GetBytes(Motor_degree)  'Convert ushort to bytes array 
                TX_DATA_RS232_BYTE_1 = Motor_degree_array(0)              'LSB Motor_degree
                TX_DATA_RS232_BYTE_2 = Motor_degree_array(1)              'MSB Motor_degree

                Motor_position_array = BitConverter.GetBytes(Motor_degree_now)  'Convert ushort to bytes array 
                TX_MOTOR_POSITION_BYTE_1 = Motor_position_array(0)              'LSB Motor_degree_now
                TX_MOTOR_POSITION_BYTE_2 = Motor_position_array(1)              'MSB Motor_degree_now
                SEND_DATA_TO_PIC = {TX_DATA_RS232_BYTE_1, TX_DATA_RS232_BYTE_2, Motor_Command, TX_MOTOR_POSITION_BYTE_1, TX_MOTOR_POSITION_BYTE_2}
                SerialPort.Write(SEND_DATA_TO_PIC, 0, SEND_DATA_TO_PIC.Length)
                PIC_Command_Answer = 0

            End If

        End If



    End Sub
    Public Sub indique_reponse_pic()

        Select Case (PIC_Command_Answer)

            Case 3

                PIC_Answer_Box.Text = "Last step received"

            Case 4

                PIC_Answer_Box.Text = "Home set"

            Case 5

                PIC_Answer_Box.Text = "Pic Ready"

            Case 6

                PIC_Answer_Box.Text = "Driver disabled"
                LED_Verte.Visible = False
                LED_rouge.Visible = True  'Led rouge qui indique aucune réponse du PIC ou driver L6208 désactivé
        End Select

    End Sub
    Public Sub Calculate_Step_motor()  'calcul les pas du moteur à faire en fonction de la position actuelle


        If Motor_degree_now >= Previous_Motor_degree Then

            Motor_Command = 1
            Motor_degree = Motor_degree_now - Previous_Motor_degree

        End If


        If Motor_degree_now < Previous_Motor_degree Then 'on tourne le moteur dans l'autre sens

            Motor_Command = 2
            Motor_degree = Previous_Motor_degree - Motor_degree_now

        End If

        Previous_Motor_degree = Motor_degree_now



    End Sub

    Public Sub Get_Motor_position_from_pic()
        Motor_Command = 3      'indique une requete pour avoir la dernière position du moteur
        SEND_DATA_TO_PIC = {TX_DATA_RS232_BYTE_1, TX_DATA_RS232_BYTE_2, Motor_Command, TX_MOTOR_POSITION_BYTE_1, TX_MOTOR_POSITION_BYTE_2}
        SerialPort.Write(SEND_DATA_TO_PIC, 0, SEND_DATA_TO_PIC.Length)

    End Sub
    Public Sub Set_Motor_position()

        Motor_Command = 4      'indique une commande pour mettre la position courante à 1 
        Motor_degree = 1
        Motor_degree_now = 1
        Previous_Motor_degree = 1
        TrackBar1.Value = Motor_degree_now
        ProgressBar1.Value = 1
        Degree_TextBox.Text = Motor_degree

        Motor_degree_array = BitConverter.GetBytes(Motor_degree)  'Convert ushort to bytes array 
        TX_DATA_RS232_BYTE_1 = Motor_degree_array(0)              'LSB Motor_degree
        TX_DATA_RS232_BYTE_2 = Motor_degree_array(1)              'MSB Motor_degree

        Motor_position_array = BitConverter.GetBytes(Motor_degree_now)  'Convert ushort to bytes array 
        TX_MOTOR_POSITION_BYTE_1 = Motor_position_array(0)              'LSB Motor_degree_now
        TX_MOTOR_POSITION_BYTE_2 = Motor_position_array(1)              'MSB Motor_degree_now

        SEND_DATA_TO_PIC = {TX_DATA_RS232_BYTE_1, TX_DATA_RS232_BYTE_2, Motor_Command, TX_MOTOR_POSITION_BYTE_1, TX_MOTOR_POSITION_BYTE_2}

        SerialPort.Write(SEND_DATA_TO_PIC, 0, SEND_DATA_TO_PIC.Length)
        indique_reponse_pic()

    End Sub

    Private Sub COM_Select_Box_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles COM_Select_Box.SelectedIndexChanged

        SerialPort.Close()

        Select Case (COM_Select_Box.SelectedIndex)


            Case 0
                Port_selected = COM_Select_Box.SelectedItem
                Open_com_port()

            Case 1
                Port_selected = COM_Select_Box.SelectedItem
                Open_com_port()
            Case 2
                Port_selected = COM_Select_Box.SelectedItem
                Open_com_port()
            Case 3
                Port_selected = COM_Select_Box.SelectedItem
                Open_com_port()
            Case 4
                Port_selected = COM_Select_Box.SelectedItem
                Open_com_port()

        End Select


    End Sub

    Public Sub Open_com_port()

        SerialPort.PortName = Port_selected
        SerialPort.BaudRate = 9600
        SerialPort.DataBits = 8
        SerialPort.Parity = IO.Ports.Parity.None
        SerialPort.StopBits = IO.Ports.StopBits.One

        Try
            SerialPort.Open()
        Catch ex As Exception
            MessageBox.Show("Le " & Port_selected & " est déja utilisé")
        End Try


        If SerialPort.IsOpen Then

            COM_Select_Box.SelectedItem = Port_selected   'Met le premier port trouvé dans la boite de sélection
            'set-up timers
            Timer1.Interval = 500 '500ms
            Timer1.Enabled = True 'start timer
            Timer2.Enabled = True 'start timer

        End If


    End Sub

    Public Sub SerialPort1_DataReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort.DataReceived
        'This sub gets called automatically when the com port recieves some data

        'Pause while all data is read
        System.Threading.Thread.Sleep(100)
        bytes = 3
        Dim PIC_ANSWER_BYTES(2) As Byte  '3 bytes à recevoir du PIC

        'Move received data into the buffer
        Try
            SerialPort.Read(PIC_ANSWER_BYTES, offset, bytes)
        Catch ex As Exception

        End Try


        Try

            Motor_degree_now = BitConverter.ToUInt16(PIC_ANSWER_BYTES, 0) 'Transforme l'array de Bytes (MSB/LSB) en integer
            PIC_Command_Answer = PIC_ANSWER_BYTES(2)                      'Réponse du PIC confirmant que la commande est recu
        Catch ex As Exception

        End Try

        

    End Sub
    Public Function StrToByteArray(ByVal str As String) As Byte()
        Dim encoding As New System.Text.UTF8Encoding()
        Return encoding.GetBytes(str)
    End Function 'StrToByteArray
    Private Sub Home_Pos_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Home_Pos.Click

        Set_Motor_position()

    End Sub

    Private Sub Timer2_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer2.Tick

        indique_reponse_pic()

        If PIC_Command_Answer = 5 Or PIC_Command_Answer = 4 Then 'Le PIC a terminé de bouger le moteur on peut activer la trackbar

            TrackBar1.Enabled = 1
        Else
            TrackBar1.Enabled = 0      'Le PIC n'a pas terminé de bouger le moteur on déscative la trackbar
        End If


        If PIC_Command_Answer = 6 Then 'Driver disabled car ca fait 3 minutes qu'il ne se passe rien

            TrackBar1.Enabled = 0      'Le PIC n'a pas terminé de bouger le moteur on déscative la trackbar
        End If


    End Sub

    Private Sub Turn_off_step_motor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Motor_Command = 6      'indique au PIC de désactiver le Driver du moteur pour sauver du courant
        SEND_DATA_TO_PIC = {TX_DATA_RS232_BYTE_1, TX_DATA_RS232_BYTE_2, Motor_Command, TX_MOTOR_POSITION_BYTE_1, TX_MOTOR_POSITION_BYTE_2}
        SerialPort.Write(SEND_DATA_TO_PIC, 0, SEND_DATA_TO_PIC.Length)
    End Sub

    Private Sub Connect_button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Connect_button.Click

        Timer1.Enabled = True 'Repars le timer1 pour demander la position au PIC

    End Sub
End Class




